// $Id: BasicDocument.h,v 1.6 2002/08/24 19:08:19 hns Exp $
//
//  CocoaBasicDocument.h
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Sat Jun 15 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <HNSAppKit/HNSSortedTableView.h>
#import <HNSAppKit/HNSSyntaxAwareTextView.h>

// location of content in the document.plist
#define Content_AppSettings			@"Info.plist"		// this resembles the Info.plist
#define Content_AppSettings_Name		@"CFBundleName"			// human readable application name
#define Content_AppSettings_AppVersion	@"CFBundleVersion"		// e.g. 2.3.5a2
#define Content_AppSettings_BndlID		@"CFBundleIdentifier"	// e.g. com.mycompany.myapp
#define Content_AppSettings_BndlVersion	@"CFBundleVersion"
#define Content_AppSettings_Creator		@"CFBundleSignature"	// e.g. 'MACx'
#define Content_AppSettings_Package		@"CFBundlePackageType"	// e.g. 'APPL', 'FMWK', 'BNDL'
#define Content_AppSettings_MainClass	@"NSPrincipalClass"
#define Content_AppSettings_ShortVersion @"CFBundleShortVersionString"
#define Content_AppSettings_Icon		@"IconData"				// icon NSImage stored as NSData
#define InfoPlist_IconFile				@"CFBundleIconFile"
#define InfoPlist_Executable			@"CFBundleExecutable"
#define InfoPlist_GetInfoString			@"CFBundleGetInfoStrings"
#define InfoPlist_GetInfoHTML			@"CFBundleGetInfoHTML"
#define InfoPlist_HelpFile				@"NSHelpFile"
#define InfoPlist_DevelopmentRegion		@"CFBundleDevelopmentRegion"
#define InfoPlist_MainNIB				@"NSMainNibFile"
#define Content_AppSettings_FileTypes		@"CFBundleDocumentTypes"			// array
#define Content_FileTypes_name				@"CFBundleTypeName"
#define Content_FileTypes_extensions		@"CFBundleTypeExtensions"	// should be array of strings
#define Content_FileTypes_ostypes			@"CFBundleTypeOSTypes"		// should be array of 4-letter strings
#define Content_FileTypes_role				@"CFBundleTypeRole"
#define Content_FileTypes_icon				@"CFBundleTypeIcon"			// should be icon+file
#define Content_FileTypes_DocumentClass		@"NSDocumentClass"
#define Content_Icons				@"Icons"				// dictionary of Icons
#define Content_Sounds				@"Sounds"				// dictionary of Sound Files
#define Content_Strings				@"Strings"				// dictionary of Local Language Translations Strings
#define Content_HelpFiles			@"Help"					// dictionary of Help Files
#define Content_Resources			@"Resources"			// Array of Resource Files
#define Content_Resources_Name			@"Name"				// Name of Resource Files
#define Content_Resources_Type			@"Type"				// Type of Resource Files
#define Content_Resources_Type_Std			@"Resources"	// copy to Resources
#define Content_Resources_Type_Plugin		@"Plugin"		// copy to Plugins
#define Content_Resources_Location			@"Location"		// Location of Resource Files - if added by reference
#define Content_Resources_Value				@"Value"		// NSData/NSFileWrapper Resource File Contents - if added by copy
#define Content_Classes				@"Classes"				// dictionary of Classes
#define Content_Class_name					@"class"		// used as column name in table view
#define Content_Class_Superclass			@"superclass"	// if available
#define Content_Class_Type					@"classtype"	// bundle name: builtin, plugin-name, defined
#define Content_Class_Type_UserDefined			@"Application"
#define Content_Class_Properties			@"properties"	// dictionary of properties (i.e. instance variables and methods)
#define Content_Class_Property_name				@"property"	// used as column name in table view
#define Content_Class_Property_typeIvar				@""		// this name prefix identifies instance variables
#define Content_Class_Property_typeCmethod			@"+"	// this name prefix identifies class methods
#define Content_Class_Property_typeImethod			@"-"	// this name prefix identifies instance methods
#define Content_Class_Property_type				@"class"	// class of Instance variable or method return type
// #define Content_Class_Property_inherited		@"inherited"	// "true" if property is inherited from superclass
// this means that the method arguments and (return) type can't be changed - unless changed in the superclass
// otherwise its a user defined (new) method
#define Content_Class_Property_access			@"access"	// public/protected/private
#define Content_Class_Property_outlet			@"outlet"	// outlet status
#define Content_Class_Method_category			@"category"	// category name this method belongs to
#define Content_Class_Method_args				@"args"		// argument list and types
#define Content_Class_Method_source				@"source"	// source code - if available
#define Content_Class_Method_icode				@"CocoaScript"	// intermediate script code
#define Content_Class_Method_code				@"code"		// compiled code
// same as for C_Method
#define Content_Instances			@"NIBs"			// dictionary of NIB-File contents
#define Content_Instances_name					@"instance"		// used as column name in table view
#define Content_Instances_Class					@"class"		// class of instance
#define Content_Instances_Group					@"nibfile"		// group, i.e. name of nib-file to collect in
#define Content_Instances_Ivars					@"Ivars"		// dictionary
#define Content_Instances_Ivar_name					@"variable"	// used as column name in table view
#define Content_Instances_Ivar_type					@"type"		// will be extracted from class/properties
#define Content_Instances_Ivar_value				@"value"	// initial value

#define Content_NameOf_Executable			@"RunTime"
#define Content_NameOf_MainInstance			@"MainMenu"
#define Content_NameOf_MainHelpFile			@"Help"				// Main Help File
#define Content_NameOf_MainIconFile			@"AppMain"			// Main Icon File

// #import does not work properly???
@class BasicDocumentWindowController;

@interface BasicDocument : NSDocument {
	// browser window
	IBOutlet NSWindow *browserwindow;			// the class&instance browser window
	IBOutlet HNSSortedTableView *classlist;		// the list of classes
	NSArray *allClassKeys;						// temporary to speed up display
	IBOutlet NSPopUpButton *classfilter;
	IBOutlet HNSSortedTableView *instancelist;	// the list of instances
	NSArray *allInstanceKeys;					// temporary to speed up display
	// class editor
	NSMutableDictionary *editedclass;		// temporary pointer
	BOOL editedClassNeedsSaving;
	IBOutlet NSWindow *classeditor;			// the class editor window
//	IBOutlet NSFormCell *classname;
//	IBOutlet id supername;
	// property editor (part of class editor)
	NSMutableDictionary *editedproperty;	// temporary pointer
	BOOL editedPropertyNeedsSaving;
	IBOutlet NSFormCell *typename;			// result type or variable type
	IBOutlet NSFormCell *methodname;		// method or variable name
	IBOutlet NSFormCell *methodargs;		// method arguments
	IBOutlet id outletsetting;
	IBOutlet HNSSortedTableView *propertylist;
	IBOutlet NSPopUpButton *propertyfilter;
	NSArray *allPropertyKeys;					// temporary to speed up display
	IBOutlet HNSSyntaxAwareTextView *codeeditor;		// BASIC code
	// source editor (part of property editor)
	IBOutlet NSDrawer *sourceeditor;		// the intermediate source code editor drawer
	IBOutlet NSTextView *sourcecode;		// cocoa script editor
	IBOutlet NSTableView *objectcode;		// script object code
	IBOutlet NSTextView *scriptresult;		// script result window
//	CocoaScript *cocoascript;				// compiled code as a cocoa script for display in objectcode
	// instance editor
	IBOutlet NSWindow *instanceeditor;		// the instance editor window
	IBOutlet NSWindow *menueditor;			// the menu editor window
	IBOutlet NSWindow *windoweditor;		// the window editor window
	NSMutableDictionary *editedinstance;	// temporary pointer
	BOOL editedInstanceNeedsSaving;
//	IBOutlet NSFormCell *instancename;
//	IBOutlet id instanceclass;
	IBOutlet HNSSortedTableView *valuelist;
	NSArray *allValueKeys;					// temporary to speed up display
	// debugger windows
	IBOutlet NSWindow *debugger;
	IBOutlet NSTableView *callstack;
	IBOutlet NSButton *runbutton;
	IBOutlet NSButton *stopbutton;
	IBOutlet NSButton *killbutton;
	IBOutlet NSButton *stepbutton;
	IBOutlet NSButton *stepinbutton;
	IBOutlet NSButton *stepoutbutton;
	//	BasicCompileInterpret *runningapp;	// if launched
	NSTask *debugapp;		// debug session of compiled application
	BOOL stopped;
 //	BOOL running;						// is running (or interrupted)
	// file type editing
	IBOutlet NSWindow *filetypes;		// browser
	IBOutlet HNSSortedTableView *filetypelist;	// list of all filetypes
	IBOutlet NSWindow *filetypeeditor;
	IBOutlet NSFormCell *filetypename;
	IBOutlet NSFormCell *filetypeextensions;
	IBOutlet NSFormCell *filetypeostypes;
	IBOutlet NSPopUpButton *filetyperole;
	// application settings
	IBOutlet NSWindow *appsettings;
	IBOutlet NSFormCell *appname;
	IBOutlet NSFormCell *appcreator;
	IBOutlet NSImageView *appiconview;
	IBOutlet NSPopUpButton *applanguage;
	IBOutlet NSFormCell *appversion;
	IBOutlet NSFormCell *shortversion;
	IBOutlet NSFormCell *bundleid;
	IBOutlet NSFormCell *bundleversion;
	IBOutlet NSPopUpButton *defaultwindow;		// should be Principal Class
	IBOutlet NSButton *appbuild;	// title changes dynamically
	BOOL appSettingsNeedsSaving;	// has been changed
	// help file manager
	IBOutlet NSWindow *helpeditor;
	IBOutlet NSTextView *helpeditortext;
	IBOutlet HNSSortedTableView *helpfilelist;
	// strings manager
	IBOutlet NSWindow *stringeditor;
	IBOutlet HNSSortedTableView *stringlist;
	// resources manager
	IBOutlet NSWindow *resourcesWindow;		// browser
	IBOutlet HNSSortedTableView *resourceslist;
	// internal data
	NSMutableDictionary *content;		// document content
	// pointers into content
	NSMutableDictionary *classes;
	NSMutableDictionary *instances;
	NSMutableArray *resources;
	NSMutableDictionary *settings;
	NSMutableArray *ftypes;
	NSMutableDictionary *strings;
	NSMutableDictionary *icons;
	NSMutableDictionary *sounds;
	NSMutableDictionary *helpfiles;
	// compiler interface
	Class compiler;						// reference to BasicCompiler plugin
}

// helper functions
- (void) touch;
- (void) setContentPointers;
- (void) setContentPointers:(NSString *) language;

// get resources
- (id) valueInResourcesTable:(NSString *)column row:(int)rowIndex;

// get file types
- (id) valueInFileTypeTable:(NSString *)column row:(int)rowIndex;

// get classes
- (id) valueInClassTable:(NSString *)column row:(int)rowIndex;
- (void) setValue:(id)val inClassTable:(NSString *)column row:(int)rowIndex;
- (id) valueInPropertyTable:(NSString *)col row:(int)rowIndex;	// of the currently active class
- (void) setValue:(id)val inPropertyTable:(NSString *)col row:(int)rowIndex;	// of the currently active class

// get instances
- (id) valueInInstanceTable:(NSString *)column row:(int)rowIndex;
- (void) setValue:(id)val inInstanceTable:(NSString *)column row:(int)rowIndex;
- (id) valueInValueTable:(NSString *)column row:(int)rowIndex;	// of the currently active instance
- (void) setValue:(id)val inValueTable:(NSString *)column row:(int)rowIndex;	// of the currently active instance

// get call stack (may be nil if no application is launched)
// - (NSArray *) callstack;	// get call stack

// FirstResponder Menu actions
- (IBAction) import:(id)Sender;
- (IBAction) export:(id)Sender;

- (IBAction) buildApplication:(id)Sender;	// open Build panel
- (IBAction) appSettings:(id)Sender;		// open Application settings
- (IBAction) changeAppSettings:(id)Sender;	// target for some visual elements

- (IBAction) openDebugger:(id)Sender;	// open debugger window
- (IBAction) run:(id)Sender;			// run application in debugger
- (IBAction) kill:(id)Sender;			// kill application
- (IBAction) interrupt:(id)Sender;		// interrupt application
- (IBAction) step:(id)Sender;			// single step application
- (IBAction) stepIn:(id)Sender;			// single step application
- (IBAction) stepOut:(id)Sender;		// single step application
- (IBAction) stopapp:(id)Sender;		// stop application

- (IBAction) compileSource:(id) Sender;	// compile current source to intermediate code

- (IBAction) newClass:(id)Sender;			// subclass of currently selected class
- (IBAction) newApplicationSubclass:(id)Sender;	// subclass of class NSApplication
- (IBAction) newDocumentSubclass:(id)Sender;	// subclass of class NSDocument
- (IBAction) newViewSubclass:(id)Sender;		// subclass of class NSView
- (IBAction) newObjectSubclass:(id)Sender;		// subclass of class NSObject
- (IBAction) newInstance:(id)Sender;
- (IBAction) newMenu:(id)Sender;		// instance of class NSMenu
- (IBAction) newWindow:(id)Sender;		// instance of class NSWindow
- (IBAction) newMethod:(id)Sender;
- (IBAction) newVariable:(id)Sender;
- (IBAction) newAction:(id)Sender;
- (IBAction) newOutlet:(id)Sender;

- (IBAction) editClass:(id) Sender;
- (IBAction) filterClass:(id) Sender;		// classfilter has changed
- (IBAction) deleteClass:(id) Sender;
- (IBAction) duplicateClass:(id) Sender;
- (IBAction) editInstance:(id) Sender;
- (IBAction) deleteInstance:(id) Sender;
- (IBAction) duplicateInstance:(id) Sender;
- (IBAction) filterProperty:(id) Sender;	// propertyfilter changed
- (IBAction) deleteProperty:(id) Sender;
- (IBAction) duplicateProperty:(id) Sender;
- (IBAction) editCode:(id) Sender;
- (IBAction) editWindow:(id) Sender;
- (IBAction) editMenu:(id) Sender;

- (IBAction) openFiletypes:(id) Sender;
- (IBAction) openResources:(id) Sender;
- (IBAction) openHelpfile:(id) Sender;
- (IBAction) openStrings:(id) Sender;

	// button actions
- (IBAction) buildOk:(id)Sender;		// ok button (Build/Set) pressed
- (IBAction) chooseIcon:(id)Sender;
- (IBAction) saveHelp:(id) Sender;		// save changes done in the help file editor
- (IBAction) previewHelp:(id) Sender;	// preview in Help viewer
- (IBAction) importHelp:(id) Sender;	// import HTML file or folder
- (IBAction) newHelp:(id) Sender;		// create new help file
- (IBAction) deleteHelp:(id) Sender;	// delete help file
- (IBAction) saveStrings:(id) Sender;	// save changes done in the String editor
- (IBAction) newString:(id) Sender;		// create new String
- (IBAction) deleteString:(id) Sender;	// delete String
- (IBAction) newFileType:(id) Sender;
- (IBAction) editFileType:(id) Sender;
- (IBAction) saveFileType:(id) Sender;
- (IBAction) deleteFileType:(id) Sender;
- (IBAction) compileCode:(id) Sender;	// compile current intermediate to runtime
- (IBAction) runCode:(id) Sender;

// table actions
- (IBAction) tableClick:(HNSSortedTableView *)aTableView;
- (IBAction) tableDoubleClick:(HNSSortedTableView *)aTableView;

@end
